package parser;

import tokens.*;
import scheme.*;

public class BinOpFac extends ATVFactory {
    private OpsFac _opsFac;
    
    /**
     * Visitor for E grammar non-terminals.
     */
    private ITokVisitor _parseOp;
    
    /**
     * Initializer lambda for this factory.
     */
    private ILambda _initializer = new ILambda() {
        public Object apply(Object nu) {
            _initializer = NoOpLambda.Singleton;
            _parseOp = _opsFac.makeVisitor();
            return null;
        }
    };
    
    /**
     * @param _opsFac 
     */
    public BinOpFac(ITokenizer tkz, OpsFac _opsFac) {
        super(tkz);
        this._opsFac = _opsFac;
    }
    
    /**
     * Make a token visitor.
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        initialize();
        return new LeftPToken.ILeftPVisitor() {
            public Object leftPCase(LeftPToken host, Object inp) {
                return new BinOp(host, (IOps)nextToken().execute(_parseOp, inp));
            }

            public Object defaultCase(AToken host, Object nu) {
                throw new IllegalArgumentException("Wrong token: expect '(' but get '" + host + "'");
            }
        };    
    }
    
    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     * @param successor visitor to serve as successor in the chain
     * @return 
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        initialize();
        return new LeftPToken.AChainVis(successor) {
            public Object leftPCase(LeftPToken host, Object inp) {
                return new BinOp(host, (IOps)nextToken().execute(_parseOp, inp));
            }
        };
    }
    
    /**
     * Make the visitor.
     */
    private void initialize() {
        _initializer.apply(null);

    }
}

