
package parser;

import tokens.*;

public class EFac extends ATVFactory {
    private LeafFac _leafFac;
    private BinOpFac _binOpFac;
    
    /**
     * @param _leafFac 
     * @param _binOpFac 
     */
    public EFac(ITokenizer tkz, LeafFac _leafFac, BinOpFac _binOpFac) {
        super(tkz);
        this._leafFac = _leafFac;
        this._binOpFac = _binOpFac;
    }
    
    
    /**
     * @return token visitor to parse E
     */
    public ITokVisitor makeVisitor() {
        return _leafFac.makeChainedVisitor(_binOpFac.makeVisitor());
    }
    
    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     * *
     * @param successor visitor to serve as successor in the chain
     * @return token visitor to parse E
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return _leafFac.makeChainedVisitor(_binOpFac.makeChainedVisitor(successor));
    }
}

