
package parser;

import tokens.*;

public class LeafFac extends ATVFactory {
    private VarLeafFac _varLeafFac;
    private NumLeafFac _numLeafFac;
    
    /**
     * @param _varLeafFac 
     * @param _numLeafFac 
     */
    public LeafFac(ITokenizer tkz, VarLeafFac _varLeafFac, NumLeafFac _numLeafFac) {
        super(tkz); 
        this._varLeafFac = _varLeafFac;
        this._numLeafFac = _numLeafFac;
    }
    
    /**
     * Make a token visitor.
     * *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return _varLeafFac.makeChainedVisitor(_numLeafFac.makeVisitor());
    }
    
    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     * *
     * @param successor visitor to serve as successor in the chain
     * @return 
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return _varLeafFac.makeChainedVisitor(_numLeafFac.makeChainedVisitor(successor));
    }
}

