
package parser;

import tokens.*;
import scheme.*;

public class MulFac extends ATVFactory {
    private EFac _eFac1;
    private EFac _eFac2;
    private ITokVisitor _parseE1;
    private ITokVisitor _parseE2;
    
    /**
     * Initializer lambda for this factory.
     */
    private ILambda _initializer = new ILambda() {
        public Object apply(Object nu) {
            _initializer = NoOpLambda.Singleton;
            _parseE1 = _eFac1.makeVisitor();
            _parseE2 = _eFac2.makeVisitor();
            return null;
        }
    };
    
    public MulFac(ITokenizer tkz) {
        super(tkz);
    }
    
    public void setEFac(EFac e) {
        _eFac1 = e;
        _eFac2 = e;
    }

    
    /**
     * @param _eFac1 
     * @param _eFac2 
     */
    public MulFac(ITokenizer tkz, EFac _eFac1, EFac _eFac2) {
        super(tkz);
        this._eFac1 = _eFac1;
        this._eFac2 = _eFac2;
    }
    
    /**
     * Make a token visitor.
     * *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        initialize();
        return new MultToken.IMultVisitor() {
            public Object multCase(MultToken host, Object inp) {
                IE e1 = (IE)nextToken().execute(_parseE1, inp);
                IE e2 = (IE)nextToken().execute(_parseE2, inp);
                return new Mul(host, e1, e2, (RightPToken)nextToken().execute(_matchRightP, null));
            }

            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Wrong token: '" + host + "'");
            }
        };    }
    
    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     * *
     * @param successor visitor to serve as successor in the chain
     * @return 
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        initialize();
        return new MultToken.AChainVis(successor) {
            public Object multCase(MultToken host, Object inp) {
                IE e1 = (IE)nextToken().execute(_parseE1, inp);
                IE e2 = (IE)nextToken().execute(_parseE2, inp);
                return new Mul(host, e1, e2, (RightPToken)nextToken().execute(_matchRightP, null));
            }
        };
    }
    
    private void initialize() {
        _initializer.apply(null);
    }
    
    private ITokVisitor _matchRightP = new RightPToken.IRightPVisitor(){
        public Object rightPCase(RightPToken host, Object nu) {
            return host;
        }
        
        public Object defaultCase(AToken host, Object nu) {
            throw new IllegalArgumentException("Wrong token: '" + host + "'");
        }
    };
}

