
package parser;

import tokens.*;
import scheme.*;

public class NumLeafFac extends ATVFactory {
    public NumLeafFac(ITokenizer tkz) {
        super(tkz);
    }
    /**
     * Make a token visitor.
     * *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return new NumToken.INumVisitor() {
            public Object numCase(NumToken host, Object inp) {
                return new NumLeaf(host);
            }

            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Wrong token: '" + host + "'");
            }
        };    }
    
    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     * *
     * @param successor visitor to serve as successor in the chain
     * @return 
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return new NumToken.AChainVis(successor) {
            public Object numCase(NumToken host, Object inp) {
                return new NumLeaf(host);
            }
        };
    }
}

