
package parser;

import tokens.*;

public class OpsFac extends ATVFactory {
    private AddFac _addFac;
    private MulFac _mulFac;
    
    /**
     * @param _addFac 
     * @param _mulFac 
     */
    public OpsFac(ITokenizer tkz, AddFac _addFac, MulFac _mulFac) {
        super(tkz);
        this._addFac = _addFac;
        this._mulFac = _mulFac;
    }
    
    /**
     * Make a token visitor.
     * *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return _addFac.makeChainedVisitor(_mulFac.makeVisitor());
    }
    
    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     * *
     * @param successor visitor to serve as successor in the chain
     * @return 
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return _addFac.makeChainedVisitor(_mulFac.makeChainedVisitor(successor));
    }
}

