
package parser;

import tokens.*;
import scheme.*;

public class VarLeafFac extends ATVFactory {
    public VarLeafFac(ITokenizer tkz) {
        super(tkz);
    }
    /**
     * Make a token visitor.
     * *
     * @return token visitor
     */
    public ITokVisitor makeVisitor() {
        return new IdToken.IIdVisitor() {
            public Object idCase(IdToken host, Object inp) {
                return new VarLeaf(host);
            }

            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Wrong token: '" + host + "'");
            }
        };    }
    
    /**
     * Make a token visitor that delegates to the given visitor in a chain of responsibility.
     * *
     * @param successor visitor to serve as successor in the chain
     * @return 
     */
    public ITokVisitor makeChainedVisitor(ITokVisitor successor) {
        return new IdToken.AChainVis(successor) {
            public Object idCase(IdToken host, Object inp) {
                return new VarLeaf(host);
            }
        };
    }
}

