package tokens;

/**
 * token A class.
 */
public class TokenA extends AToken {

    public static interface ITokAVisitor extends ITokVisitor {

        public Object tokACase(TokenA host, Object param);
    }


    public static abstract class AChainVis implements ITokAVisitor {
        private ITokVisitor _successor;

        protected AChainVis(ITokVisitor successor) {
            _successor = successor;
        }

        public Object defaultCase(AToken host, Object param) {
            return host.execute(_successor, param);
        }
    }

    public final static TokenA Singleton = new TokenA();
    private TokenA() {
        super("a");
    }

    public Object execute(ITokVisitor algo, Object param) {
        return (algo instanceof ITokAVisitor) ?
               ((ITokAVisitor) algo).tokACase(this, param) :
               algo.defaultCase(this, param);
    }
}

