package treeNAlgo;
import treeN.*;

/**
 * Converts a 2-3-4 tree to a Red-Black tree.
 * @author DXN
 */
public class From234ToRedBlack implements ITreeNAlgo {
    public static final From234ToRedBlack Singleton = new From234ToRedBlack();
    private From234ToRedBlack() {
    }
    
    /**
     * Perform recursively the following operation from the bottom of the tree
     * up towards the root:
     * Splits a 3 children node into a 2 children node ( like a binary tree)
     * whose root contains a Black decorated object, and whose left subtree
     * has a root that contains a Red decorated object.
     * 
     * Splits a 4 children node into a 2 children node ( like a binary tree)
     * whose root contains a Black decorated object, and whose left and right
     * subtrees with Red decorated object roots.
     * 
     * See Page 4 of the lecture note on Red-Black Tree.
     */
    public Object caseAt(int i, TreeN host, Object... nu) {
        switch(i) {
            case 0: {
                return host;
            }
            case 1: {
                // This is the case with 1 data and 2 children subtrees.
                // Decorate the root data as Black and recurse down the left 
                // and right subtrees.
                // STUDENT TO COMPLETE
                
                return host;
            }
            case 2: {
                // This is the case with 2 data and 3 children subtrees.
                // Recurse down the subtrees and split up the root node
                // as specified.
                // STUDENT TO COMPLETE
                
                return host;
            }
            case 3: {
                // This is the case with 3 data and 4 children subtrees.
                // Recurse down the subtrees and split up the root node
                // as specified.
                // STUDENT TO COMPLETE
                
                return host;
            }            
            default: {
                return host;
            }
        }
    }
}