package treeNAlgo;

import treeN.*;

/**
 * Splits host upwards if its state &gt; order and passes the host to the
 * supplied param, which is an ISpliceCmd, to do some "abstract splicing".
 */
class SplitUpAndSplice implements ITreeNAlgo {
    
    int order;
    /**
     * Installs no-op cmd for states <= order
     */
    public SplitUpAndSplice(int order) {
        this.order = order;
    }
    
    public Object caseAt(int i, TreeN host, Object... param) {
        if(i<=order) {
            return host;
        }
        else {
            host.splitUpAt((i - dither()) / 2);   // push data up
            return ((ILambda)param[0]).apply(host); // "splice" host into something!
        }
    }
    
    private final int dither() {
        return (int)(2 * Math.random());
    }
}

