package treeNAlgo;
import treeN.*;

/**
 * Vertical display of a TreeN.
 */
public class ToStringAlgo implements ITreeNAlgo {
    private static ToStringAlgo instance = new ToStringAlgo();
    
    public static ToStringAlgo Singleton() { return instance; }
    
    private ToStringAlgo() {}
    
    public Object caseAt(int idx, TreeN host, Object... nu) {
        switch(idx) {
            case 0: {
                return "[ ]";
            }
            default: {
                String sData= "", sTrees="";
                for(int i = 0;i<idx;i++) {
                    sData += host.getDat(i)+" ";
                    sTrees += host.getChild(i).execute(toStringHelp,"|  ")+"\n";
                }
                sTrees += host.getChild(idx).execute(toStringHelp,"   ").toString();
                return sData +"\n"+sTrees;
            }
        }
    }
    //----------- helper algo --------------------------------------------------
    final private ITreeNAlgo toStringHelp = new ITreeNAlgo() {
        public Object caseAt(int idx, TreeN host, Object... prefix) {
            switch(idx) {
                case 0: {
                    return "|_[ ]";
                }
                default: {
                    String sData= "", sTrees="";
                    for(int i = 0;i<idx;i++) {
                        sData += host.getDat(i)+" ";
                        sTrees += prefix[0]
                            + (String) host.getChild(i).execute(this, prefix[0]+"|  ")+"\n";
                    }
                    sTrees += prefix[0] + host.getChild(idx).execute(this,prefix[0]+"   ").toString();
                    return "|_ "+sData +"\n"+sTrees;
                }
            }
        }
    };
}
