/*
 * Decompiled with CFR 0.152.
 */
package treeN;

import java.util.Vector;
import treeN.ITreeNAlgo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeN {
    private Vector<TreeN> _children = new Vector();
    private Vector<Object> _data = new Vector();

    public TreeN() {
    }

    public TreeN(Integer n) {
        this(new TreeN(), n, new TreeN());
    }

    private TreeN(Vector<Object> data, Vector<TreeN> children) {
        this._data = data;
        this._children = children;
    }

    private TreeN(TreeN lTree, Object n, TreeN rTree) {
        this._data.add(n);
        this._children.add(lTree);
        this._children.add(rTree);
    }

    public Object getDat(int idx) {
        return this._data.get(idx);
    }

    public TreeN getChild(int idx) {
        return this._children.get(idx);
    }

    public Object setDat(int idx, Object e) {
        Object r = this._data.get(idx);
        this._data.set(idx, e);
        return r;
    }

    public TreeN spliceAt(int idx, TreeN tree) {
        int i = tree._data.size();
        if (i > 0) {
            if (this._data.size() > 0) {
                this._children.set(idx, tree.getChild(i--));
            } else {
                this._children.add(idx, tree.getChild(i--));
            }
            while (i >= 0) {
                this._data.add(idx, tree.getDat(i));
                this._children.add(idx, tree.getChild(i));
                --i;
            }
        }
        return this;
    }

    public TreeN splitUpAt(int idx) {
        if (this._data.size() > 1) {
            Vector<Object> newData = new Vector<Object>();
            Vector<TreeN> newChildren = new Vector<TreeN>();
            Object rootDat = this._data.remove(idx);
            for (int i = 0; i < idx; ++i) {
                newData.add(this._data.remove(0));
                newChildren.add(this._children.remove(0));
            }
            newChildren.add(this._children.remove(0));
            TreeN lTree = newData.size() > 0 ? new TreeN(newData, newChildren) : (TreeN)newChildren.firstElement();
            TreeN rTree = this._data.size() > 0 ? new TreeN(this._data, this._children) : this._children.firstElement();
            this._data = new Vector<Object>();
            this._data.add(rootDat);
            this._children = new Vector<TreeN>();
            this._children.add(lTree);
            this._children.add(rTree);
        }
        return this;
    }

    public TreeN splitDownAt(int idx) {
        if (this._data.size() > 1) {
            TreeN newChild = new TreeN(this.getChild(idx), this._data.remove(idx), this.getChild(idx + 1));
            this._children.remove(idx);
            this._children.set(idx, newChild);
        } else {
            this._data.clear();
            this._children.clear();
        }
        return this;
    }

    public Object execute(ITreeNAlgo algo, Object ... param) {
        return algo.caseAt(this._data.size(), this, param);
    }
}

