package parser;

import rules.*;
import tokens.*;

public class BFact extends ATVFactory {
    private YFact yFact;
    private ITokVisitor _parseY;
    
    private ILambda _initializer = new ILambda() {
        public Object apply(Object nu) {
            _initializer = NoOpLambda.Singleton;
            _parseY = yFact.makeVisitor();
            return null;
        }
    };
    
    public BFact(ITokenizer tkz) {
        super(tkz);
    }
    
    public void setYFact(YFact yf) {
        yFact = yf;
    }
    
    public ITokVisitor makeVisitor() {
        _initializer.apply(null);
        return new TokenB.ITokBVisitor() {
            public Object tokBCase(TokenB host, Object param) {
                return new B(host, (AY)nextToken().execute(_parseY, param));
            }
            
            public Object defaultCase(AToken host, Object param) {
                throw new IllegalArgumentException("Expect " + TokenB.Singleton + " but get " + host);
            }
        };
    }
    
    public ITokVisitor makeChainedVisitor(ITokVisitor succ) {
        _initializer.apply(null);
        return new TokenB.AChainVis(succ) {
            public Object tokBCase(TokenB host, Object param) {
                return new B(host, (AY)nextToken().execute(_parseY, param));
            }
        }; 
    }
}

