package parser;

import rules.*;
import tokens.*;

public class SFact extends ATVFactory {
    private XFact xFact;
    private YFact yFact;
    
    private ITokVisitor _parseX;
    private ITokVisitor _parseY;
    
    /**
     * Initializer lambda for this factory.
     */
    private ILambda _initializer = new ILambda() {
        public Object apply(Object nu) {
            _initializer = NoOpLambda.Singleton;
            _parseX = xFact.makeVisitor();
            _parseY = yFact.makeVisitor();
            return null;
        }
    };
    
    public SFact(ITokenizer tkz, XFact xf, YFact yf) {
        super(tkz);
        xFact = xf;
        yFact = yf;
    }
    
    public ITokVisitor makeVisitor() {
        _initializer.apply(null);
        return new ITokVisitor() {
            public Object defaultCase(AToken host, Object inp) {
                return new S((AX)host.execute(_parseX, inp),
                             (AY)nextToken().execute(_parseY, inp));
            }        
        };
    }
    
    public ITokVisitor makeChainedVisitor(final ITokVisitor succ) {
        _initializer.apply(null);
        return new ITokVisitor() {
            public Object defaultCase(AToken host, Object inp) {
                Object o = host.execute(xFact.makeChainedVisitor(succ), inp);
                return (o instanceof AX)? new S((AX)o, (AY)nextToken().execute(_parseY, inp)): o;
            }        
        };
    }
}

