package t234Client;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import treeN.*;
import treeNAlgo.*;

public class T234Frame extends JFrame {
    
    TreeN myTree = new TreeN();
    
    JPanel contentPane;
    BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel1 = new JPanel();
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JButton deleteBtn = new JButton();
    private JTextField inputTF = new JTextField();
    private JButton clearBtn = new JButton();
    private JButton enterRndBtn = new JButton();
    private JButton redBlackBtn = new JButton("Red Black Tree");
    private JButton two34Btn = new JButton("2-3-4 Tree");
    
    //Construct the frame
    public T234Frame() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        try {
            jbInit();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
        showTree();
    }
    
    //Component initialization
    private void jbInit() throws Exception  {
        contentPane = (JPanel) this.getContentPane();
        contentPane.setLayout(borderLayout1);
        this.setFont(new java.awt.Font("Dialog", 1, 20));
        this.setSize(new Dimension(1227, 838));
        this.setTitle("Frame Title");
        deleteBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        deleteBtn.setText("Delete");
        deleteBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                deleteBtn_actionPerformed(e);
            }
        }
        );
        inputTF.setFont(new java.awt.Font("Dialog", 1, 20));
        inputTF.setPreferredSize(new Dimension(100, 31));
        inputTF.setText("0");
        inputTF.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                inputTF_actionPerformed(e);
            }
        }
        );
        clearBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        clearBtn.setText("Clear");
        clearBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                clearBtn_actionPerformed(e);
            }
        }
        );
        enterRndBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        enterRndBtn.setText("Enter Random #");
        enterRndBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                enterRndBtn_actionPerformed(e);
            }
        }
        );
        algoTestBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        algoTestBtn.setText("Algo test");
        algoTestBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                algoTestBtn_actionPerformed(e);
            }
        }
        );
        playBackBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        playBackBtn.setText("Playback");
        playBackBtn.addActionListener(new java.awt.event.ActionListener()  {
            
            public void actionPerformed(ActionEvent e) {
                playBackBtn_actionPerformed(e);
            }
        }
        );
        playBackRestartBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        playBackRestartBtn.setText("Playback restart");
        playBackRestartBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                playBackRestartBtn_actionPerformed(e);
            }
        }
        );
        jPanel2.setLayout(gridLayout1);
        gridLayout1.setColumns(1);
        gridLayout1.setRows(-1);
        playbackClrBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        playbackClrBtn.setText("Playback Clear");
        playbackClrBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                playbackClrBtn_actionPerformed(e);
            }
        }
        );
        playbackLbl.setFont(new java.awt.Font("Dialog", 1, 20));
        playbackLbl.setText("no values");
        splitBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        splitBtn.setText("Split At");
        splitBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e)  {
                splitBtn_actionPerformed(e);
            }
        });
        jPanel3.setLayout(gridLayout2);
        gridLayout2.setColumns(1);
        gridLayout2.setRows(-1);
        orderBtn.setFont(new java.awt.Font("SansSerif", 1, 20));
        orderBtn.setText("Change Order");
        orderBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                orderBtn_actionPerformed(e);
            }
        });

        redBlackBtn.setFont(new java.awt.Font("SansSerif", 1, 20));
        redBlackBtn.addActionListener(new java.awt.event.ActionListener() {            
            public void actionPerformed(ActionEvent e) {
                redBlackBtn_actionPerformed(e);
            }
        });        

        two34Btn.setFont(new java.awt.Font("SansSerif", 1, 20));
        two34Btn.addActionListener(new java.awt.event.ActionListener() {            
            public void actionPerformed(ActionEvent e) {
                two34Btn_actionPerformed(e);
            }
        });        
        
        jPanel4.setLayout(gridLayout3);
        gridLayout3.setColumns(1);
        gridLayout3.setRows(-1);
        orderTF.setFont(new java.awt.Font("SansSerif", 1, 20));
        orderTF.setText("3");
        orderTF.setHorizontalAlignment(SwingConstants.RIGHT);
        rndInsTstBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        rndInsTstBtn.setText("Rnd InsTst");
        rndInsTstBtn.addActionListener(new java.awt.event.ActionListener() {            
            public void actionPerformed(ActionEvent e) {
                rndInsTstBtn_actionPerformed(e);
            }
        });
        outputLbl2.setFont(new java.awt.Font("SansSerif", 1, 20));
        refreshBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        refreshBtn.setPreferredSize(new Dimension(120, 37));
        refreshBtn.setText("Refresh");
        refreshBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                refreshBtn_actionPerformed(e);
            }
        }
        );
        resultLbl.setText("Result");
        outputTA.setFont(new java.awt.Font("Dialog", 1, 28));
        outputTA.setMinimumSize(new Dimension(0, 37));
        jPanel5.setLayout(gridLayout4);
        gridLayout4.setColumns(2);
        gridLayout4.setHgap(5);
        gridLayout4.setVgap(5);
        jPanel5.setMinimumSize(new Dimension(32767, 32767));
        jScrollPane1.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        rndDelTstBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        rndDelTstBtn.setText("Rnd Del Tst");
        rndDelTstBtn.addActionListener(new java.awt.event.ActionListener() {
            
            public void actionPerformed(ActionEvent e) {
                rndDelTstBtn_actionPerformed(e);
            }
        }
        );
        findBtn.setFont(new java.awt.Font("Dialog", 1, 20));
        findBtn.setMaximumSize(new Dimension(79, 37));
        findBtn.setMinimumSize(new Dimension(79, 37));
        findBtn.setPreferredSize(new Dimension(79, 37));
        findBtn.setText("Find");
        findBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(ActionEvent e) {
                findBtn_actionPerformed(e);
            }
        }
        );
        jPanel1.add(clearBtn, null);
        jPanel1.add(rndInsTstBtn, null);
        jPanel1.add(rndDelTstBtn, null);
        jPanel1.add(findBtn, null);
        jPanel1.add(inputTF, null);
        jPanel1.add(deleteBtn, null);
        jPanel1.add(resultLbl, null);
        jPanel1.add(enterRndBtn, null);
        jPanel1.add(algoTestBtn, null);
        jPanel1.add(splitBtn, null);
        jPanel1.add(refreshBtn, null);
        contentPane.add(jScrollPane1, BorderLayout.CENTER);
        jScrollPane1.getViewport().add(jPanel5, null);
        jPanel5.add(outputTA, null);
        contentPane.add(jPanel2, BorderLayout.WEST);
        jPanel2.add(playbackLbl, null);
        jPanel2.add(playBackBtn, null);
        jPanel2.add(playBackRestartBtn, null);
        jPanel2.add(playbackClrBtn, null);
        jPanel2.add(jPanel4, null);
        jPanel4.add(orderTF, null);
        jPanel4.add(orderBtn, null);
        jPanel4.add(redBlackBtn, null);
        jPanel4.add(two34Btn, null);
        jPanel2.add(jPanel3, null);
        jPanel3.add(outputLbl2, null);
        contentPane.add(jPanel1, BorderLayout.NORTH);
    }
    
    //Overridden so we can exit when window is closed
    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            System.exit(0);
        }
    }
    
    //    tree234.ToStringAlgo toStringAlgo = new tree234.ToStringAlgo();
    treeNAlgo.ToStringAlgo toStringAlgo = treeNAlgo.ToStringAlgo.Singleton();
    private JButton algoTestBtn = new JButton();
    
    void showTree()  {
        // System.out.println( myTree.execute(toStringAlgo, null) ); // Throw off the amenities of a TextArea!
        
        outputTA.setText((String) myTree.execute(toStringAlgo));
        jScrollPane1.validate();
        if(playIdx < playVec.size())
            playbackLbl.setText("playback value= "+playVec.elementAt(playIdx));
        else playbackLbl.setText("no more values");
    }
    
    Vector<Integer> playVec = new Vector<Integer>();
    int playIdx = 0;
    
    void deleteBtn_actionPerformed(ActionEvent e)  {
        deleteValue(new Integer(inputTF.getText()));
        showTree();
    }
    
    void clearBtn_actionPerformed(ActionEvent e)  {
        myTree = new TreeN();
        showTree();
    }
    
    void inputTF_actionPerformed(ActionEvent e)  {
        insertValue(new Integer(inputTF.getText()));
        showTree();
    }
    
    void enterRndBtn_actionPerformed(ActionEvent e) {
        insertValue(new Integer((int)(1000*Math.random())));
        showTree();
    }
    
    //    InsertAlgo insertAlgo = new InsertAlgo();
    //    Insert234Algo insertAlgo = new Insert234Algo(3);
    
    ITreeNAlgo insertAlgo = new InsertNAlgo(3);
    
    ITreeNAlgo deleteAlgo = new DeleteNAlgo(3);
    
    void insertValue(Integer n) {
        playVec.add(n);
        myTree.execute(insertAlgo, n);
    }
    void deleteValue(Integer n) {
        resultLbl.setText(""+ myTree.execute(deleteAlgo, n));
    }
    
    private JPanel jPanel2 = new JPanel();
    private JButton playBackBtn = new JButton();
    private JButton playBackRestartBtn = new JButton();
    private GridLayout gridLayout1 = new GridLayout();
    private JButton playbackClrBtn = new JButton();
    private JLabel playbackLbl = new JLabel();
    private JButton splitBtn = new JButton();
    private JPanel jPanel3 = new JPanel();
    private GridLayout gridLayout2 = new GridLayout();
    private JLabel outputLbl2 = new JLabel();
    private JPanel jPanel4 = new JPanel();
    private JButton orderBtn = new JButton();
    private GridLayout gridLayout3 = new GridLayout();
    private JTextField orderTF = new JTextField();
    private JButton rndInsTstBtn = new JButton();
    JButton refreshBtn = new JButton();
    JLabel resultLbl = new JLabel();
    JPanel jPanel5 = new JPanel();
    JTextArea outputTA = new JTextArea();
    GridLayout gridLayout4 = new GridLayout();
    JButton rndDelTstBtn = new JButton();
    JButton findBtn = new JButton();
    
    void algoTestBtn_actionPerformed(ActionEvent e) {
        insertValue(new Integer(20));
        insertValue(new Integer(10));
        insertValue(new Integer(35));
        insertValue(new Integer(30));
        insertValue(new Integer(40));
        insertValue(new Integer(55));
        insertValue(new Integer(45));
        insertValue(new Integer(50));
        insertValue(new Integer(60));
        showTree();
        
    }
    
    void playBackBtn_actionPerformed(ActionEvent e) {
        if(playIdx < playVec.size())
            myTree.execute(insertAlgo, playVec.elementAt(playIdx++));
        showTree();
    }
    
    void playBackRestartBtn_actionPerformed(ActionEvent e) {
        playIdx = 0;
        showTree();
    }
    
    void playbackClrBtn_actionPerformed(ActionEvent e) {
        playVec.clear();
        playIdx = 0;
        showTree();
    }
    
    void splitBtn_actionPerformed(ActionEvent e) {
        myTree.splitUpAt(Integer.parseInt(inputTF.getText()));
        showTree();
    }
    
    void orderBtn_actionPerformed(ActionEvent e) {
        insertAlgo = new InsertNAlgo(Integer.parseInt(orderTF.getText()));
        deleteAlgo = new DeleteNAlgo(Integer.parseInt(orderTF.getText()));
    }

    void redBlackBtn_actionPerformed(ActionEvent e) {
        myTree.execute(From234ToRedBlack.Singleton);
        showTree();
    }

    void two34Btn_actionPerformed(ActionEvent e) {
        myTree.execute(RBto234.Singleton);
        showTree();
    }
    
    void rndInsTstBtn_actionPerformed(ActionEvent e) {
        for(int i=0;i<100;i++) enterRndBtn_actionPerformed(e);
    }
    
    void refreshBtn_actionPerformed(ActionEvent e) {
        showTree();
    }
    void rndDelTstBtn_actionPerformed(ActionEvent e) {
        for(int i=0;i<100;i++){
            deleteValue(new Integer((int)(1000*Math.random())));
        }
        showTree();
    }
    
    void findBtn_actionPerformed(ActionEvent e) {
        Object[] result = (Object[])myTree.execute(new FindNAlgo(),
                                                   new Integer(inputTF.getText()));
        resultLbl.setText(""+result[1]);
        System.out.println(""+((TreeN)result[0]).execute(toStringAlgo));
    }
}
