package treeN;

/**
 * Decorating an Object to mark it with Red or Black.
 * Red and Black are implemented as subclasses.
 * @author DXN
 */
abstract public class ARBObject {
    private Object _dat;
    
    /**
     * Decorates the given raw data.
     * @param dat the raw data.
     */
    public ARBObject(Object dat) {
        _dat = dat;
    }
    
    /**
     * Get the unmarked raw data.
     */
    public Object getObject() {
        return _dat;
    }
    
    public String toString() {
        return _dat + " " + color();
    }
    
    abstract public String color();
    
    /**
     * Hook method for visitors.
     */
    abstract public Object execute(IRBVisitor v, Object... inp);
}

