package kochModel;
import java.awt.*;
import fp.*;

/**
 * The abstract state of Koch.   This embodies the notion of  Koch being in either a base or non-base case state.
 * Since the grow and paint methods of Koch depend on its state, they are dispatched on out to the concrete states polymorphically.
 * For these internal methods calls, an extra parameter is added; the Koch object which is the context under which
 * the method is operating.  All references to the  actual Koch object go through the public accessor methods.
 */
public abstract class AKochState {
//  abstract void grow(IFactory factory, Koch context);

//  abstract void paint(Graphics g, Koch context);

 /**
  * @param host 
  */
// abstract int count(Koch host);
 
 abstract Object execute(Koch host, IKochVisitor algo, Object...param);
 abstract <R,P> Object fold(Koch host, IFoldAlgo<Koch,R,P> algo, R base, P... param);

}
