package kochModel;
import java.awt.*;
import fp.*;



/**
 * This is the base case state for the Koch curve.   This state is graphically represented as a straight line.
 * @dependency kochModel.DrawManyState instantiates
 * @dependency kochModel.IFactory uses
 */
class DrawOneState extends AKochState
{
/**
  * This method transitions the Koch curve out of the base case to the non-null case.
  * The supplied factory is used create a new Koch object in its DrawManyState, given two endpoints.
     * The endpoints are supplied by the Koch context.  To transition the context itself to a DrawManyState
       * the state is extracted from the manufactured Koch object and installing it into the Koch context.
  * @param factory The factory to be used to make the state transition.
  * @param context The Koch object that is the context in which the state transition is being done.  This supplies the endpoints and receives the state from the new Koch object.
  */
// void grow(IFactory factory, Koch context)
// {
//  context.setKochState(factory.makeMany(context.getA(),context.getB()).getKochState());
// }

 /**
  * Paints a straight line on the graphical object "g" between the two points held in the "context"..
  * @param g The Graphics object upon which to draw.
  * @param context The Koch object that is the context of this state.
  */
// void paint(Graphics g, Koch context)
// {
//  g.drawLine((int) Math.round(context.getA().x),(int)Math.round(context.getA().y),
//                          (int)Math.round(context.getB().x),(int) Math.round(context.getB().y));
// }

 /**
  * @param host
  * @return
  */
// int count(Koch host)
// {
//
//  return (1);
// }
 
 public Object execute(Koch host, IKochVisitor algo, Object...param) {
   return algo.baseCase(host, param);
 }

 public <R,P> Object fold(Koch host, IFoldAlgo<Koch,R,P> algo, R base, P... param) {
   return base;
 }
 
}

