package kochModel;

import fp.*;
import java.awt.*;
import lrs.*;

import kochModel.*;
import java.awt.geom.Point2D.Double;
/**
 * This class represents a Koch curve between two points.   The Koch curve may be either a straight line or
 * a collection of line segments.
 */
public class Koch implements IFoldHost<Koch> {
  private Double a;
  private Double b;
  private AKochState aKochState = new DrawOneState();
  /**
   * Constructor for a base case Koch curve.
   * @param a The beginning point.
   * @param b The ending point.
   * @SBGen Constructor assigns a, b
   */
  public Koch(Double a, Double b)
  {
    // SBgen: Assign variables
    this.a = a;
    this.b = b;
    // SBgen: End assign
  }
  
  /**
   * Constructor for the non-base case Koch curve.
   * @param kochList The list of Koch curves needed by the  DrawManyState
   */
  public Koch(Double a, Double b, LRStruct kochList)
  {
    this(a, b);
    aKochState = new DrawManyState(kochList);
  }
  
  /**
   * "Grows" the curve by recursively changing base state Koch curves into non-base state curves by using a supplied factory object.
   * @param factory The factory object used to construct theThe factory used to change the state of the base case Koch curve.
   */
// public void grow(IFactory factory)
// {
//  aKochState.grow(factory,this);
// }
  
  /**
   * Recursively paints the Koch curve.   Should be called from an overriden paint() method of a Component.
   * @param g The graphics object onto which the curve is painted.
   */
// public void paint(Graphics g)
// {
//  aKochState.paint(g,this);
// }
  
  /**
   * Accessor method for the first point of the curve.
   * @return
   * @SBGen Method get a
   */
  public Double getA()
  {
    // SBgen: Get variable
    return(a);
  }
  
  /**
   * Accessor method for the last point of the curve.
   * @return
   * @SBGen Method get b
   */
  public Double getB()
  {
    // SBgen: Get variable
    return(b);
  }
  
  /**
   * Sets the state of the Koch curve to the supplied state.   Used internally only.
   *
   */
  void setKochState(AKochState aKochState)
  {
    this.aKochState = aKochState;
  }
  
  AKochState getKochState()
  {
    return aKochState;
  }
  
// public int count()
// {
//  return aKochState.count(this);
// }
  
  public Object execute(IKochVisitor algo, Object... param) {
    return aKochState.execute(this, algo, param);
  }
  
  public <R,P> Object fold(IFoldAlgo<Koch,R,P> algo, R base, P... param) {
    return aKochState.fold(this,algo, base, param);
  }
  
  /**
   * sets A & B points and internal state to be the same as other Koch's 
   */
  public void shareState(Koch other) {
    a = other.getA();
    b = other.getB();
    setKochState(other.getKochState());
  }
}

