package kochModel.factory;

import kochModel.*;

import lrs.*;
//import java.awt.*;
import java.awt.geom.Point2D.Double;

import fp.*;

public abstract class FractalFactory implements IFactory {
  
  private Koch proto;
  
  public Koch getProto() {
    return proto;
  }
  
  public void  setProto(Koch aProto) {
    proto = aProto;
  }
  
  public Koch makeOne(Double a, Double b) {
    return new Koch(a, b);
  }
  
  public Koch makeMany(Double a, Double b) {
    Double delta = new Double((double)(b.x-a.x), (double)(b.y-a.y));
    Double a2 = new Double((double) a.x, (double) a.y);
    final AffineXForm affineXForm = new AffineXForm(a2, delta);
    
    IKochVisitor xfmVisitor = new IKochVisitor() {
      IKochVisitor thisXfmVisitor = this;
      public Object baseCase(Koch host, Object... param) {
        return new Koch(affineXForm.doXForm(host.getA()), affineXForm.doXForm(host.getB()));
      }
      
      public Object inductCase(Koch host, Object... param) {
        LRStruct children = (LRStruct) host.fold( new IFoldAlgo<Koch, LRStruct, Object>() {
          public LRStruct apply( Koch host, LRStruct base, Object... nu) {
            base.insertFront(host.execute(thisXfmVisitor));
            return base;
          }
        }, new LRStruct());
        return new Koch(affineXForm.doXForm(host.getA()), affineXForm.doXForm(host.getB()), 
                        children);
      }      
    };
    
    return (Koch) proto.execute(xfmVisitor);  
  }
  
}
