package kochModel.factory;


import lrs.*;
import java.awt.*;
import java.awt.geom.Point2D.Double;

import kochModel.*;

/**
 * A special factory that will create initally creates a non-base case Koch curve consisting of  Koch curves constructed by the stored factory
 * in a triangle.   After that, the factory used to grow the curve is the same as stored factory.
 */
public class SnowflakeFactory implements IFactory
{

  IFactory aFactory;
  /**
  * The constructor simply saves the supplied factory for later use.
  */
 public SnowflakeFactory(IFactory aFactory)
  {
     this.aFactory = aFactory;
  }

 /**
  * Creates a Koch curve consisting of a triangle of Koch curves generated by the stored factory's makeOne() method.
  * @param a The starting point for the base of the triangle.
  * @param b The ending point for the base of the triangle.
  * @return A Koch curve.
  */
 public Koch makeOne(Double a, Double b)
 {
     LRStruct kochList = new LRStruct();
     double vx = b.x - a.x;
     double vy = b.y - a.y;
     Double c = new Double( a.x + vx/2 - ((Math.sqrt(3.0)/2.0)*vy),
          a.y + vy/2 + ((Math.sqrt(3.0)/2.0)*vx));

     kochList.insertFront(aFactory.makeOne(a,b));
     kochList.insertFront(aFactory.makeOne(b,c));
     kochList.insertFront(aFactory.makeOne(c,a));
     return new Koch(a, b, kochList);
 }


 /**
  * Constructs the list of Koch curves from the prototype list  and changes the state of the context Koch object by delegating the call to the stored factory.
  * @param context The Koch object context in which the growing is taking place.
  */
 public Koch makeMany(Double a, Double b)
 {
  return aFactory.makeMany(a,b);
//    return makeOne(a,b);
 }
}