package kochModel.factory;


import lrs.*;
import java.awt.*;
import java.awt.geom.Point2D.Double;

import kochModel.*;
import kochModel.visitor.*;

/**
 * A special factory that will create initally creates a non-base case Koch curve consisting of  Koch curves constructed by the stored factory
 * in a triangle.   After that, the factory used to grow the curve is the same as stored factory.
 */
public class SnowflakeFractalFactory extends FractalFactory
{
  
  IFactory aFactory;
  /**
   * The constructor simply saves the supplied factory for later use.
   */
  public SnowflakeFractalFactory(IFactory aFactory)
  {
    this.aFactory = aFactory;
    Double p0 = new Double(0.0, 0.0);
    Double p1 = new Double(1.0, 0.0);
    Double p2 = new Double(0.5, Math.sqrt(3.0)/2.0);
    
    LRStruct children = new LRStruct();
    children.insertFront(aFactory.makeOne(p0, p1));
    children.insertFront(aFactory.makeOne(p1, p2));
    children.insertFront(aFactory.makeOne(p2, p0));
    setProto(new Koch(p0, p1, children));

  }
  
  /**
   * Creates a Koch curve consisting of a triangle of Koch curves generated by the stored factory's makeOne() method.
   * @param a The starting point for the base of the triangle.
   * @param b The ending point for the base of the triangle.
   * @return A Koch curve.
   */
  public Koch makeOne(Double a, Double b)
  {
    return super.makeMany(a, b);
  }
  
  
  /**
   * Constructs the list of Koch curves from the prototype list  and changes the state of the context Koch object by delegating the call to the stored factory.
   * @param context The Koch object context in which the growing is taking place.
   */
  public Koch makeMany(Double a, Double b) {
    return aFactory.makeMany(a,b);
  }
}