package kochModel.visitor;

import fp.*;
import kochModel.*;

public class CountVisitor implements IKochVisitor, IFoldAlgo<Koch, Integer, Object> {
  
  public static final CountVisitor Singleton = new CountVisitor();
  
  private CountVisitor() {}
  
  public Object baseCase(Koch host, Object... param) {
    return 1;
  }
  
  public Object inductCase(Koch host, Object... param) {
    return host.fold(this, 0);
  }
  
  public Integer apply( Koch host, Integer base, Object... param) {
    return base + (Integer) host.execute(this);
  }

}