package kochModel.visitor;

import fp.*;
import kochModel.*;

public class GrowVisitor implements IKochVisitor, IFoldAlgo<Koch, Object, IFactory> {
  
  public static final GrowVisitor Singleton = new GrowVisitor();
  
  private GrowVisitor() {}
  
  public Object baseCase(Koch host, Object... fac) {
//    host.setKochState(((IFactory)fac[0]).makeMany(host.getA(),host.getB()).getKochState());
    host.shareState(((IFactory)fac[0]).makeMany(host.getA(),host.getB()));
    return null;
  }
  
  public Object inductCase(Koch host, Object... fac) {
    return host.fold(this, null, (IFactory)fac[0]);
  }
  
  public Object apply( Koch host, Object base, IFactory... fac) {
    return host.execute(this, fac[0]);
  }

}