package kochModel.visitor;

import fp.*;
import kochModel.*;
import java.awt.*;
import java.util.*;

public class PaintColorVisitor implements IKochVisitor, IFoldAlgo<Koch, Object, Graphics> {
  
  public static final PaintColorVisitor Singleton = new PaintColorVisitor();
  
  private PaintColorVisitor() {}
  
  private Random rand = new Random();
  
  private int currentRed = 128;
  private int currentGreen = 128;
  private int currentBlue = 128;
  private int delta = 10;
  
  public Object baseCase(Koch host, Object... g) {    
    paint(host, (Graphics)g[0]);
    return null;
  }
  
  public Object inductCase(Koch host, Object... g) {
    paint(host, (Graphics)g[0]);
    return host.fold(this, null, (Graphics)g[0]);
  }
  
  public Object apply( Koch host, Object base, Graphics... g) {
    return host.execute(this, g[0]);
  }

  private void paint(Koch host, Graphics g) {
        g.setColor(new Color(currentRed, currentGreen, currentBlue));
        currentRed = (256+currentRed+rand.nextInt(2*delta)-delta)%256;
        currentGreen = (256+currentGreen+ rand.nextInt(2*delta)-delta)%256;
        currentBlue = (256+currentBlue + rand.nextInt(2*delta)-delta)%256;

        g.drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
                          (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));

  }
}