package kochModel.visitor;

import fp.*;
import kochModel.*;
import java.awt.Graphics;

public class PaintNoParentVisitor implements IKochVisitor, IFoldAlgo<Koch, Object, Graphics> {
  
  public static final PaintNoParentVisitor Singleton = new PaintNoParentVisitor();
  
  private PaintNoParentVisitor() {}
  
  public Object baseCase(Koch host, Object... g) {
    ((Graphics)g[0]).drawLine((int) Math.round(host.getA().x),(int)Math.round(host.getA().y),
                          (int)Math.round(host.getB().x),(int) Math.round(host.getB().y));
    return null;
  }
  
  public Object inductCase(Koch host, Object... g) {
    return host.fold(this, null, (Graphics)g[0]);
  }
  
  public Object apply( Koch host, Object base, Graphics... g) {
    return host.execute(this, g[0]);
  }

}