package digest;

import junit.framework.TestCase;


public class Digest_Test extends TestCase {
  
  private int[] data;
  
  
  public void test_digest() {
    System.out.println("\n\n----- TEST_DIGEST ------------------------------");
    double errorRate = 0.5;
    int numTests = 200;
    int dataLength = 256;
    int maxValue = 256;
    int digestLength = 8;

    RandomErrorGenerator randErrGen = new RandomErrorGenerator(errorRate, maxValue);
        
    data = DataFactory.makeData(dataLength, maxValue); 
    
    DigestFactory digestFac = new DigestFactory(digestLength);
    int[] digest0 = digestFac.makeDigest(data);
    
    printIntVector("digest0", digest0);
    
    int data1[] = new int[dataLength];
    
    int[] digest1;
    for(int i=0; i< numTests; i++) {
      System.arraycopy(data, 0, data1, 0, dataLength);
      boolean isUnchanged = randErrGen.makeError(data1);
      System.out.println("isUnchanged = "+ isUnchanged);
      // printIntVector("data", data);
      digest1 = digestFac.makeDigest(data1);
      // printIntVector("digest1", digest1);
      assertEquals("Digest comparison", isUnchanged, compareDigests(digest0, digest1));
      assertTrue("Digest has value exceeding 255!", isLessThanMax(maxValue, digest1));
    }
  }
  
  public void test_std_dev() {
    System.out.println("\n\n----- TEST_STD_DEV ------------------------------");
    double errorRate = 1.0;
    int numTests = 200;
    int dataLength = 256;
    int maxValue = 256;
    RandomErrorGenerator randErrGen = new RandomErrorGenerator(errorRate, maxValue);
    data = DataFactory.makeData(dataLength, maxValue);
    
    int digestLength = 8;
    StatsFactory statFac = new StatsFactory(digestLength);
    
    
    DigestFactory digestFac = new DigestFactory(digestLength);
    int[] digest0 = digestFac.makeDigest(data);
    printIntVector("digest0", digest0);
    statFac.add(digest0);
    
    int data1[] = new int[dataLength];
    int[] digest1;
    for(int i=0; i< numTests; i++) {
      System.arraycopy(data, 0, data1, 0, dataLength);
      boolean isUnchanged = randErrGen.makeError(data1);
      // System.out.println("isUnchanged = "+ isUnchanged);
      // printIntVector("data", data);
      digest1 = digestFac.makeDigest(data1);
      //printIntVector("digest1", digest1);
      statFac.add(digest1);      
    }
    double stdDev = statFac.getStdDev();
    System.out.println("Std. Dev. = "+stdDev);
    double[] avg = statFac.getAvg();
    printDoubleVector("Avg. digest", avg);
    double avgLength = vectorLength(avg);
    System.out.println("Avg. length = "+avgLength);
    
    assertTrue("Std. deviation must be at least 100.0!", stdDev>100.0);
  }
  
  
  public void test_avg() {
    System.out.println("\n\n----- TEST_AVG ------------------------------");
    double errorRate = 1.0;
    int numTests = 1000;
    int dataLength = 256;
    int maxValue = 256;
    RandomErrorGenerator randErrGen = new RandomErrorGenerator(errorRate, maxValue);
    data = DataFactory.makeData(dataLength, maxValue);
    
    int digestLength = 8;
    StatsFactory statFac = new StatsFactory(digestLength);
    
    
    DigestFactory digestFac = new DigestFactory(digestLength);
    int[] digest0 = digestFac.makeDigest(data);
    printIntVector("digest0", digest0);
    statFac.add(digest0);
    
    int data1[] = new int[dataLength];
    int[] digest1;
    for(int i=0; i< numTests; i++) {
      data1 = DataFactory.makeData(dataLength, maxValue);
      //System.arraycopy(data, 0, data1, 0, dataLength);
      boolean isUnchanged = randErrGen.makeError(data1);
      // System.out.println("isUnchanged = "+ isUnchanged);
      // printIntVector("data", data);
      digest1 = digestFac.makeDigest(data1);
      //printIntVector("digest1", digest1);
      statFac.add(digest1);      
    }
    double stdDev = statFac.getStdDev();
    System.out.println("Std. Dev. = "+stdDev);
    double[] avg = statFac.getAvg();
    printDoubleVector("Avg. digest", avg);
    double avgLength = vectorLength(avg);
    System.out.println("Avg. length = "+avgLength);
    assertTrue("Length of average must be less than 50.0!", avgLength<50.0);
  }  
  /**
   * Utility method to see if two digests are equal.
   * @param d1 A digest to compare
   * @param d2 A digest to compare
   * @return true if every element of the two digests is equal, false otherwise.
   */
  boolean compareDigests(int[] d1, int[] d2) {
    boolean result = true;
    for(int i = 0; i<d1.length && result; i++) {
      result &= (d1[i] == d2[i]);
    }
    return result;
  }
  
  /**
   * Utility method to print an array of doubles.
   */
  private void printDoubleVector(String s, double[] v) {
    System.out.print(s+" = ");
    for(int i=0; i< v.length; i++) {
      System.out.print(v[i]+" ");
    }
    System.out.print("\n");
  }
  
  /**
   * Utility method to print an array of ints.
   */
  private void printIntVector(String s, int[] v) {
    System.out.print(s+" = ");
    for(int i=0; i< v.length; i++) {
      System.out.print(v[i]+" ");
    }
    System.out.print("\n");
  }
  
  
  /**
   * Utility method to calculate the length of a vector
   */
  private double vectorLength(double[] v) {
    double length = 0.0;
    for(double x: v) length += x*x;
    return Math.sqrt(length);
  }
  
  private boolean isLessThanMax(int max, int[] v) {
    for(int x: v) {
      if(Math.abs(x) >= max) return false;
    }
    return true;
  }
  
}
