package digest;

/**
 * A utility class to generate a single "error" in a data set
 */
public class RandomErrorGenerator {
  private double errorRate;  // prob. of creating an error.  0 <= errorRate <= 1
  private int maxValue;   // maximum value allowed for the data
  /**
   * Constructs an instance of the class with the given error rate, which 
   * is the probability of generating an error.
   * @param errorRate Probability of an error.  0 <= errorRate <= 1
   */
  public RandomErrorGenerator(double errorRate, int maxValue){
    this.errorRate = errorRate;
    this.maxValue = maxValue;
  }
  
  /**
   * If an error is induced, this method will change only one value 
   * in the given data by either incrementing it or decrementing it
   * by 1 with equal probability.
   * @param data The data to possibly generate the error in. 
   * @return true if no error was induced, false otherwise
   */
  public boolean makeError(int[] data) {
    if(Math.random() < errorRate) {
      int i = (int) (data.length*Math.random());
      int delta =(2*(int)(2.0*Math.random()))-1;
      //System.out.println("Error generated: data["+i+"] += "+delta);
      data[i] = (data[i]+delta)%maxValue;
      return false;
    }
    else {
      return true;
    }
  }
}