package genvisitor;

/**
 * A host to a generic visitor
 * 
 * @param I The type of the index value a host uses identify itself
 * @param H The abstract type of the host that the visitors are expecting to see. Note that this may be a subclass of IGenVisitorHost 
 */
public interface IGenVisitorHost<I, H extends IGenVisitorHost<I, H>> {
  
  /**
   * Executes a visitor
   * 
   * @param R The return type of the visitor
   * @param P The vararg parameter type of the visitor
   * @param algo The generic visitor
   * @param inps The vararg input parameters to the visitor
   */
  public <R,P> R execute(IGenVisitor<R, I, P, H> algo, P... inps);
}