package parser;

import genvisitor.*;

/**
 * Plus token class.
 */
public class PlusToken extends AToken {
    /**
     * Singleton instance.
     */
    public final static PlusToken Singleton = new PlusToken();

    /**
     * Private singleton constructor.
     */
    private PlusToken() {
        super("+");
    }

    /**
     * Execute the plus case of the visitor.
     *
     * @param algo  visitor
     * @param param visitor-specific parameter
     * @return visitor-specific return value
     */
    public <R, P> R execute(IGenVisitor<R, String, P, AToken> algo, P... inps) {
        return algo.caseAt("+", this, inps);
    }
}

