package model;

import extvisitor.*;
import java.util.*;

/** This class represents a graph, consisting of individual nodes.
  * The nodes are identified uniquely by their names, i.e. there is
  * a mapping from names to nodes. */
public class Graph {
    /** The map from names to nodes. */
    protected HashMap<String,Node> _nodes = new HashMap<String,Node>();
    
    /** Create an empty graph. */
    public Graph() { }
    /** Create a graph with the specified nodes.
      * @param nodes nodes in the graph */
    public Graph(Node... nodes) {
        for(Node n: nodes) { _nodes.put(n.getName(), n); }
    }

    /** Return the map from names to nodes.
      * @return map from names to nodes */
    public HashMap<String,Node> getNodes() {
        return _nodes;
    }
    
    /** Return a string representation of the graph.
      * @return string representation */
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for(Node n: _nodes.values()) {
            sb.append(n);
            sb.append(" ->");
            for(Node nn: n.getNeighbors()) {
                sb.append(' ');
                sb.append(nn.getName());
            }
            sb.append(";\n");
        }
        String s = sb.toString();
        return (s.length()>0)?s.substring(0,s.length()-1):"";
    }
}
