package parser;
import extvisitor.*;

/**
 * Abstract grammar token that has a name.
 * Executes the case in the visitor corresponding to its name.
 */
public abstract class AGrammarSymbol implements IGrammarSymbol {
  private String _name;
  
  public AGrammarSymbol(String name) {
    _name = name;
  }
  
  public String getName() {
    return _name;
  }

  public <R, P> R execute(IExtVisitor<R, String, P, IGrammarSymbol> algo, P... inps){
    return algo.caseAt(_name, this, inps);
  }
  
}