package parser;
import token.*;
import token.tokenizer.*;

/**
 * Abstract factory for a token visitor.
 */
public abstract class ATokVisitorFact implements ITokVisitorFact {
    /**
     * Tokenizer.
     */
    private ITokenizer _tokenizer;

    /**
     * Constructor for the abstract factory.
     *
     * @param tkz tokenizer to use
     */
    public ATokVisitorFact(ITokenizer tkz) {
        _tokenizer = tkz;
    }

    /**
     * Return the next token.
     *
     * @return next token
     */
    protected final Token nextToken() {
        return _tokenizer.getNextToken();
    }

    /**
     * Put the last token back into the tokenizer.
     */
    protected final void putBackToken() {
        // DXN: add putBack for the empty factory to put back token.
        _tokenizer.putBack();
    }
}

