package parser;

import token.*;
import token.tokenizer.*;

/**
 * Factory for a binary Combination grammar non-terminal objects.
 */
public class CombinationFact extends ATokVisitorFact {
  
   /**
   * The name of this instance of the factory
   */
  private String _name;

  /**
   * Factory for first grammar non-terminals.
   */
  private ITokVisitorFact _fact1;
  
  /**
   * Factory for second grammar non-terminals.
   */
  private ITokVisitorFact _fact2;
  
  /**
   * Constructor for the F factory,
   *
   * @param tkz    tokenizer to use
   * @param f1Fact factory for F1 grammar non-terminals
   * @param f2Fact factory for F2 grammar non-terminals
   */
  public CombinationFact(String name, ITokenizer tkz, ITokVisitorFact fact1, ITokVisitorFact fact2) {
    super(tkz);
    _name = name;
    _fact1 = fact1;
    _fact2 = fact2;
  }
  
  /**
   * Make a token visitor to parse an F non-terminal.
   *
   * @return token visitor
   */
  public ATokVisitor<IGrammarSymbol, Object> makeVisitor() {
    return _fact1.makeCombinedVisitor(_fact2.makeVisitor());
  }
  
  /**
   * Make a token visitor that delegates to the given visitor in a chain of responsibility
   *
   * @param other visitor to serve as other in the chain
   */
  public ATokVisitor<IGrammarSymbol, Object> makeCombinedVisitor(ATokVisitor<IGrammarSymbol, Object> other) {
    return _fact1.makeCombinedVisitor(_fact2.makeCombinedVisitor(other));
  }
}

