package parser;

import token.*;

/**
 * A proxy for a grammar token parsing factory used when the instance of 
 * a desired factory cannot be guaranteed available until execution time, 
 * such as when setting up a grammar with a loop in it.
 * Using this proxy class eliminates the need for an extraneous settor 
 * method and a special constructor for specific factories involved in a 
 * grammar loop just so that the loop can be closed.
 * Install this proxy in place of the proxied factory before the
 * proxied factory has been instantiated and then call the settor
 * below to set the reference to the proxied factory after the proxied factory
 * has been instantiated.
 */
public class ProxyFact implements ITokVisitorFact {
  
  ITokVisitorFact _fact;
  
  public void setFact(ITokVisitorFact fact) {
    _fact = fact;
  }
  
  public ATokVisitor<IGrammarSymbol, Object> makeVisitor() {
    return _fact.makeVisitor();
  }
  
  public ATokVisitor<IGrammarSymbol, Object> makeCombinedVisitor(ATokVisitor<IGrammarSymbol, Object> other){
    return _fact.makeCombinedVisitor(other);
  }
}

