package lrs;

/**
 * Represents an abstract algorithm on an LRStruct.  Acts as a visitor to a
 * LRStruct host.
 * Since LRStruct is a mutable data structure, we require an exact match for
 * the data type (LRStruct<T>, not LRStruct<? extends T>).
 * @author Dung X. Nguyen and Stephen Wong  Copyright 2005 - All rights reserved.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 * @since 8/25/05
 */
public interface IAlgo<T,R,P> {
    /**
    * Operates on an empty LRStruct host, given an input object.
    * @param host an empty LRStruct.
    * @param inp variable input list of objects needed by this IVisitor.
    * @return an appropriate output object.
    */
    public abstract R emptyCase(LRStruct<T> host, P... inp);

    /**
    * Operates on a non-empty LRStruct host, given an input object.
    * @param host a non-empty LRStruct.
    * @param inp variable input list of objects needed by this IVisitor.
    * @return an appropriate output object.
    */
    public abstract R nonEmptyCase(LRStruct<T> host, P... inp);
}

