package lrs.visitor;

import lrs.*;
import java.util.*;

/**
 * Algorithm for inserting elements into an LRStruct in order.
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class InsertInOrder<T> implements IAlgo<T, LRStruct<T>, T> {
  private Comparator<T> _order;

  public InsertInOrder(Comparator<T> ord) {
      _order = ord;
  }

  /**
  * Simply inserts the given parameter n at the front.
  * @param host an empty LRStruct.
  * @param n n[0] is an Object to be inserted in order into host,
  *   based on the given Comparator.
  * @return LRStruct<T>
  */
  public LRStruct<T> emptyCase(LRStruct<T> host, T... n) {
    return host.insertFront(n[0]);
  }

  /**
  * Based on the comparison between first and n,
  * inserts at the front or recurs!
  * @param host a non-empty LRStruct.
  * @param n n[0] is an Object to be inserted in order into host,
  *   based on the given Comparator.
  * @return LRStruct<T>
  */
  public LRStruct<T> nonEmptyCase(LRStruct<T> host, T... n) {
    if (_order.compare(n[0], host.getFirst()) < 0) {
      return ((LRStruct<T>)host).insertFront(n[0]);
    }
    else {
      return host.getRest().execute(this, n);
    }
  }
}

