package parser;

import token.*;
import extvisitor.*;

/**
 * Grammar non-terminal -- Word ::= id
 */
public class TerminalSymbol extends AGrammarSymbol {
    /**
     * Word Id token.
     */
    private Token _token;

   
    /**
     * Constructor for the Word grammar non-terminal.
     *
     * @param num number token
     */
    public TerminalSymbol(String name, Token token) {
      super(name);  
      _token = token;
    }

    /**
     * Return a string representation.
     *
     * @return string representation
     */
    public String toString() {
        return _token.toString();
    }
    


}

