package rac;
import lrs.*;

/**
 * FIFO RAC
 * @author Mathias Ricken - Copyright 2008 - All rights reserved.
 */
public class LRSQueueFactory<T> extends ALRSRACFactory<T> {
    /**
     * Create a ``first-in, first-out'' (FIFO) container.
     */
    public IRAContainer<T> makeRAC() {
        return new LRSRAContainer<T>(new IAlgo<T,LRStruct<T>,T>() {
            public LRStruct<T> emptyCase(LRStruct<T> host, T... input) {
                return host.insertFront(input[0]);
            }
            
            public LRStruct<T> nonEmptyCase(LRStruct<T> host, T... input) {
                return host.getRest().execute(this, input);
            }
        });
        
    }    
}
