package token;

import extvisitor.*;

/**
 * A visitor to an Token. 
 */
public abstract class ATokVisitor<R,P> extends AExtVisitor<R, String, P, Token> implements ITokVisitor<R, P> {
  public ATokVisitor() {
    super( new IExtVisitorCmd<R, String, P, Token>() {
      public R apply(String idx, Token host, P... inps) {
        throw new IllegalArgumentException("ATokVisitor: Unknown token encountered: "+ idx);
      }
    });
  }
  
  public ATokVisitor(ATokVisitor<R,P> other) {
    super(other);
  }  
}