package token;

import extvisitor.*;

/**
 * Abstract token class.
 */
public  class Token implements IExtVisitorHost<String, Token> {
  
  /**
   * The name of this token
   */
  String _name;
  
  /**
   * The _lexeme this token is representing.
   */
  private String _lexeme;
  
  /**
   * Token constructor.
   *
   * @param name The name associated with this token.  This is the index value when it executes its visitors.
   * @param lexeme _lexeme this token is representing.
   */
  public Token(String name, String lexeme) {
    _name = name;
    _lexeme = lexeme;
  }
  
  
  /**
   * Executes (accepts) the visitor, calling the case associated with this host's index value.
   * @param <R> The type of the return value
   * @param <P> The type of the vararg input parameter
   * @param algo The visitor to execute
   * @param params The input parameters supplied to the algo when its appropriate case is called.
   * @return The return value from executing the appropriate case on the visitor.
   */
  public <R, P> R execute(IExtVisitor<R, String, P, Token> algo,  P... params) {
    return algo.caseAt(_name, this, params);
  }
  
  /**
   * Return a string representation of the token.
   *
   * @return string representation
   */
  public String toString() {
    return _lexeme;
  }
}

