package graphs;
import java.util.*;

/**
 * Factory to make interconnected IVertexs
 */
public class GraphFactory implements IGraphFactory {
  
  /**
   * Private implementation of IVertex
   */
  private static class Vertex implements IVertex {
    /**
     * Data held at this vertex
     */
    private Object _dat;
    
    /**
     * Set of neighboring IVertexs
     * public OK here b/c class is private
     */
    public Set<IVertex> _nhbrs = new HashSet<IVertex>();
    
    /** 
     * Constructor only takes data not neighbors.
     * Neighbors will be set later by the factory.
     * puyblic constructor not publicly accedssible b/c class is private
     */
    private Vertex(Object dat) {
      _dat = dat;
    }
    
    public Object getDat() {
      return _dat;
    }
    
    public Set<IVertex> getNhbrs() {
      return _nhbrs;
    }
    
    public Object execute(IVertexAlgo algo, Object...params) {
      return algo.caseAt(_nhbrs.size(), this, params);
    }
  }
  
  public static final GraphFactory Singleton = new GraphFactory();
  private GraphFactory() {}
  
  public IVertex[] makeGraph(final Object[] data, Map<Integer,Integer[]>  edges) {
    
    Vertex[] graphs = new Vertex[data.length];
    
    // load the result array with half-built vertices.
    for(int i=0; i<data.length; i++) graphs[i] = new Vertex(data[i]);
    
    // install the neighbors into the vertices
    for(int i=0; i< data.length ; i++) {
      Integer[] nhbrs = edges.get(i);
      if(null!=nhbrs) {  // Do if there are neighbors.
        for(Integer j : nhbrs ) {
          graphs[i]._nhbrs.add(graphs[j]); 
        }
      }
    }
    return graphs;
  }
}