package graphs.rac;

import java.util.*;

/**
 * Restricted access container based on java.util.Stack.
 * Has two methods, store and retrieve;
 */
public abstract class ARAC<E> {
  
  protected Stack<E> data = new Stack<E>();
  
  public abstract E peek();
  public abstract boolean isEmpty();
  public abstract void store(E x);
  public abstract void storeAll(Set<E> s);
  public abstract E retrieve();
}

