package graphs.rac;

import java.util.*;

/**
 * Queue based on ARAC
 */
public class RACQueue<E> extends ARAC<E> {
  
  public boolean isEmpty() {
    return data.isEmpty();
  }

  public E peek() {
    return data.firstElement();
  }
  
  public void store(E x) {
    data.add(x);
  }

  public void storeAll(Set<E> s) {
    data.addAll(s);
  }
  
  public E retrieve() {
    return data.remove( 0);
  } 
}
