package graphs.rac;

import java.util.*;

/**
 * Stack based on ARAC
 */
public class RACStack<E> extends ARAC<E> {
  
  public boolean isEmpty() {
    return data.isEmpty();
  }
  
  public void store(E x) {
    data.push(x);
  }
  
  public E peek() {
    return data.peek();
  }

  public void storeAll(Set<E> s) {
    data.addAll(s);
  }
  
  public E retrieve() {
    return data.pop();
  }  
}
