package graphs.visitor;
import graphs.*;
import fp.*;
import java.util.*;

/**
 * Depth-first traversal of an IVertex using reverse accumulation
 * Handles loops.
 * Takes 3 input lambda:
 * fns[0] = no-links (base #1) case.  
 *          Takes the data as input.  
 *          Returns the recursive result.
 * fns[1] = non-zero links (inductive) case.  
 *          Takes the data plus an Set of the recursive results as inputs.
 *          Returns the new recursive result.
 * fns[2] = Loop case (base #2) case.  
 *          Used when IVertex object has been seen already.  
 *          Input is data element.
 *          Returns the recursive result.
 * 
 */
public class DFTravAlgo extends AGraphAlgo {
  
  private Set<IVertex> seen = new HashSet<IVertex>();
  
  public DFTravAlgo(){}
  
  
  protected Object case0(IVertex host, Object...fns) {
    return ((ILambda)fns[0]).apply(host.getDat());
  }
  
  protected Object defaultCase(int nNbhrs, IVertex host, Object...fns){
    if(seen.contains(host)){ // check if seen
        return ((ILambda)fns[2]).apply(host.getDat());
    }
    else {
      seen.add(host); // mark as seen before recursion
      Vector<Object> rr = new Vector<Object>();
      for(IVertex g: host.getNhbrs()) {
        rr.add(g.execute(this, fns));
      }
      seen.remove(host); // unmark after recursion
      return ((ILambda) fns[1]).apply(host.getDat(), rr);
    }
  }
}
