package lrs.visitor;

import lrs.*;
import fp.*;

/**
 * Filters an LRStruct based on a given fp.ILambda predicate.
 * Mutates the list such that all elements, x, are retained
 * where pred.apply(x)returns true.   
 * The mutated list is returned.
 */
public class FilterLRS implements IAlgo {
  
  public static final FilterLRS Singleton = new FilterLRS();
  
  private FilterLRS() {}
  
  public Object emptyCase(LRStruct host, Object pred) {
    return host;
  }
  
  public Object nonEmptyCase(LRStruct host, Object pred) {
    if((Boolean)((ILambda)pred).apply(host.getFirst())) {
      host.getRest().execute(this, pred);
    }
    else {
      host.removeFront();
      host.execute(this, pred);
    }
    return host;
  }
}