package lrs.visitor;

import lrs.*;
import fp.*;

/**
 * Captures the essence of list processing using forward accumulation.
 * empty case: foldl(empty, f, b) = b;
 * non-empty case: foldl(host, f, b) = foldl(host.rest, f, f(host, b));
 * @author D.X. Nguyen
 * @since 2004/09/20
 */
public class FoldlLRS implements IAlgo {
    private ILambda _f;
    
    public FoldlLRS(ILambda f) {
        _f = f;
    }
    public Object emptyCase(LRStruct host, Object b) {
        return b;
    }
    
    public Object nonEmptyCase(LRStruct host, Object b) {
        return host.getRest().execute(this, _f.apply(host, b));
    }
}