package lrs.visitor;
import lrs.*;
import fp.*;

/**
 * Maps the given ILambda onto every element of the host list, 
 * returning a new list.
 * empty case: map(empty, f) => empty;
 * non-empty case: map({x1, x2, x3 ...}, f) = {f(x1), f(x2), f(x3), ...};
 * The host list is unmodified.
 * This is the same as a standard immutable map in functional languages.
 */
public class MapCopyLRS implements IAlgo {
 
  public static final MapCopyLRS Singleton = new MapCopyLRS();
  
  private MapCopyLRS() {}
  
  public Object emptyCase(LRStruct host, Object fn) {
    return new LRStruct();
  }
  public Object nonEmptyCase(LRStruct host, Object fn) {
    return ((LRStruct)host.getRest().execute(this, fn)).insertFront(((ILambda) fn).apply(host.getFirst()));
  }
}
  
