package lrs.visitor;

import lrs.*;
import fp.*;

/**
 * Maps a given fp.ILambda predicate across the list.
 * Returns true if for any element x in the list, 
 * pred.apply(x)returns true.  Returns false otherwise.
 * Exhibits "short-circuit" behavior in that if pred.apply(x) 
 * every returns true, the processing of the list is 
 * immediately terminated and true is returned.
 * If the list is empty, false is returned.
 * The original list is unchanged.
 */
public class OrMapLRS implements IAlgo {
  
  public static final OrMapLRS Singleton = new OrMapLRS();
  
  private OrMapLRS() {}
  
  public Object emptyCase(LRStruct host, Object pred) {
    return false;
  }
  
  public Object nonEmptyCase(LRStruct host, Object pred) {
    if((Boolean)((ILambda)pred).apply(host.getFirst())) {
      return true;
    }
    else {
      return host.getRest().execute(this, pred);
    }
  }
}